# -*- coding: cp1252 -*-
#
#	FILE:	 WaterWorld.py
#	AUTHOR:  Toni Leppkorpi
#	PURPOSE: Global map script - map with lots of water
#-----------------------------------------------------------------------------
#	Copyleft (c) 2005
#-----------------------------------------------------------------------------
#

if __name__ != '__main__':
    from CvPythonExtensions import *
    import CvMapGeneratorUtil
    from CvMapGeneratorUtil import TerrainGenerator
    from CvMapGeneratorUtil import FeatureGenerator
else:
    #dummy code for fast command line testing
    import sys
    import random
    class CyGlobalContext:
        def getGame(self):
            return Game()

    class Game:
        def getMapRand(self):
            return Dice()
    
    class Dice:
        def get(self, n, msg):
            if n == 1:
                return 0
            return random.randint(0,n-1)

    class CyPythonMgr:
        def debugMsg(self, msg):
            print msg

    class CyFractal:
        def fracInit(self, w, h, grain, dice, flag, xe, ye):
            self.grain = grain
        def getHeightFromPercent(self, p):
            return p
        def getHeight(self, x, y):
            return random.randint(0,99)

    class CyMap:
        def getGridWidth(self):
            return 79
        def getGridHeight(self):
            return 50
        def getCustomMapOption(self, n):
            if len(sys.argv) > n+1:
                return int(sys.argv[n+1])
            else:
                return getCustomMapOptionDefault([n])
        def getSeaLevel(self):
            n = getNumCustomMapOptions()+1
            if len(sys.argv) > n:
                return int(sys.argv[n])
            else:
                return 1

    def NiTextOut(txt):
        print txt

    class PlotTypes:
        NO_PLOT = -1
        PLOT_PEAK = 0
        PLOT_HILLS = 1
        PLOT_LAND = 2
        PLOT_OCEAN = 3
        NUM_PLOT_TYPES = 4
    #dummy code ends


def getDescription():
	return "TXT_KEY_MAP_SCRIPT_WATERWORLD_DESCR"
	
def isAdvancedMap():
	"This map should show up in simple mode"
	return 0

def getGridSize(argsList):
	"Reduce grid sizes by one level."
	grid_sizes = {
		WorldSizeTypes.WORLDSIZE_DUEL:		(8,5),
		WorldSizeTypes.WORLDSIZE_TINY:		(10,6),
		WorldSizeTypes.WORLDSIZE_SMALL:		(13,8),
		WorldSizeTypes.WORLDSIZE_STANDARD:	(16,10),
		WorldSizeTypes.WORLDSIZE_LARGE:		(21,13),
		WorldSizeTypes.WORLDSIZE_HUGE:		(26,16)
	}

	if (argsList[0] == -1): # (-1,) is passed to function on loads
		return []
	[eWorldSize] = argsList
	return grid_sizes[eWorldSize]

class LakeType:
    SEAS = 0
    LARGE = 1
    SMALL = 2
    DEFAULT = SEAS

askLakeType = True
debug = False

def getOptionString():
    s = ''
    if askLakeType: s += '[LakeType 0-2] '
    s += '[SeaLevel 0-2]'
    return s

def getNumCustomMapOptions():
    n = 0
    if askLakeType: n += 1
    return n
	
def getCustomMapOptionName(argsList):
    [iOption] = argsList
    optionNames = []
    if askLakeType: optionNames.append("TXT_KEY_MAP_SCRIPT_WATER_SETTING")
    translated_text = unicode(CyTranslator().getText(optionNames[iOption], ()))
    return translated_text
	
def getNumCustomMapOptionValues(argsList):
    [iOption] = argsList
    optionValues = []
    if askLakeType: optionValues.append(3)
    return optionValues[iOption]
	
def getCustomMapOptionDescAt(argsList):
    [iOption, iSelection] = argsList
    selectionNames = []
    if askLakeType:
        selectionNames.append([
	    "TXT_KEY_MAP_SCRIPT_SEAS",
	    "TXT_KEY_MAP_SCRIPT_LARGE_LAKES",
	    "TXT_KEY_MAP_SCRIPT_SMALL_LAKES",
            ])
    translated_text = unicode(CyTranslator().getText(selectionNames[iOption][iSelection], ()))
    return translated_text

def getCustomMapOptionDefault(argsList):
    [iOption] = argsList
    optionDefaults = []
    if askLakeType: optionDefaults.append(LakeType.DEFAULT)
    return optionDefaults[iOption]

def isClimateMap():
	return 1

def isSeaLevelMap():
	return 1

def getWrapX():
	return True
def getWrapY():
	return False

class Map:
    def __init__(self, w, h):
        self.w = w
        self.h = h
	self.dice = CyGlobalContext().getGame().getMapRand()
        
        self.data = [None]*self.w
        for x in range(self.w):
            self.data[x] = [PlotTypes.NO_PLOT]*self.w

    def makeLakes(self, expansionPercent):
        newNoPlotList = []
        for x in range(self.w):
            for y in range(self.h):
                if self.data[x][y] == PlotTypes.NO_PLOT:
                    newNoPlotList.append((x,y))

        r = 1
        newNearOceanList = []
        while r > 0:
            noPlotList = newNoPlotList
            nearOceanList = newNearOceanList
            newNoPlotList = []
            newNearOceanList = []
            r = 0
            while len(noPlotList) > 0 or len(nearOceanList) > 0:
                if (self.dice.get(100, 'WaterWorld') < expansionPercent and len(nearOceanList) > 0) \
                   or len(noPlotList) == 0:
                    i = self.dice.get(len(nearOceanList), 'WaterWorld')
                    p = nearOceanList.pop(i)
                    tmpList = newNearOceanList
                else:
                    i = self.dice.get(len(noPlotList), 'WaterWorld')
                    p = noPlotList.pop(i)
                    tmpList = newNoPlotList
                x,y = p
                if self.allowLake(x,y):
                    self.data[x][y] = PlotTypes.PLOT_OCEAN
                    r = r + 1
                    for dx,dy in (-1,0),(0,1),(1,0),(0,-1):
                        nx = (x+dx)%self.w
                        ny = (y+dy)%self.h
                        p = self.data[nx][ny]
                        np = (nx,ny)
                        if p != PlotTypes.PLOT_OCEAN and np not in nearOceanList:
                            try:
                                newNearOceanList.remove(np)
                            except:
                                pass
                            try:
                                noPlotList.remove(np)
                            except:
                                pass
                            nearOceanList.append(np)
                else:
                    tmpList.append(p)

    def allowLake(self, x, y):
        land = False
        k = 0
        for dx,dy in (-1,-1),(-1,0),(-1,1),(0,1),(1,1),(1,0),(1,-1),(0,-1):
            p = self.data[(x+dx)%self.w][(y+dy)%self.h]
            if p != PlotTypes.PLOT_OCEAN:
                land = True
            elif abs(dx)+abs(dy) == 1 and land == True:
                k = k + 1
                land = False
        p = self.data[(x-1)%self.w][y]
        if p == PlotTypes.PLOT_OCEAN and land == True:
            k = k + 1
        if k >= 2:
            return False
        else:
            return True

    def removeSmallLakes(self, minSize):
        sList = []
        for x in range(self.w):
            for y in range(self.h):
                if self.data[x][y] == PlotTypes.PLOT_OCEAN:
                    sList.append((x,y))
                if self.data[x][y] == PlotTypes.NO_PLOT:
                    self.data[x][y] = PlotTypes.PLOT_LAND
        while len(sList) > 0:
            p = sList.pop()
            lakeList = [p]
            i = 0
            while i < len(lakeList):
                x,y =  lakeList[i]
                i = i + 1
                for dx,dy in (-1,0),(0,1),(1,0),(0,-1):
                    nx = (x+dx)%self.w
                    ny = (y+dy)%self.h
                    p = self.data[nx][ny]
                    if p != PlotTypes.PLOT_OCEAN:
                        continue
                    try:
                        j = sList.index((nx,ny))
                        lakeList.append(sList.pop(j))
                    except:
                        pass
            if len(lakeList) < minSize:
                for x,y in lakeList:
                    self.data[x][y] = PlotTypes.PLOT_LAND

    def countOceanSquares(self):
        i = 0
        for x in range(self.w):
            for y in range(self.h):
                if self.data[x][y] == PlotTypes.PLOT_OCEAN:
                    i += 1
        return i

    def write(self):
	mgr = CyPythonMgr()
	mgr.debugMsg('\nWaterWorld map dump:')
        for y in range(self.h):
            s = ''
            for x in range(self.w):
                if self.data[x][y] == PlotTypes.PLOT_OCEAN:
                    s += 'o'
                elif self.data[x][y] == PlotTypes.PLOT_PEAK:
                    s += 'X'
                elif self.data[x][y] == PlotTypes.PLOT_HILLS:
                    s += '+'
                elif self.data[x][y] == PlotTypes.PLOT_LAND:
                    s += '-'
                else:
                    s += '?'
            mgr.debugMsg(s)

    def makeHills(self, hillsPercent):
	hillsFrac = CyFractal()
	hillsFrac.fracInit(self.w, self.h, 5, self.dice, 0, -1, -1)
	hillsLowThreshold = hillsFrac.getHeightFromPercent(40)
	hillsHighThreshold = hillsFrac.getHeightFromPercent(40+hillsPercent)
        for x in range(self.w):
            for y in range(self.h):
                p = self.data[x][y]
                val = hillsFrac.getHeight(x,y)
                if hillsLowThreshold <= val < hillsHighThreshold:
                    if p == PlotTypes.NO_PLOT or p == PlotTypes.PLOT_LAND:
                        self.data[x][y] = PlotTypes.PLOT_HILLS

    def getPlotTypes(self):
	plotTypes = [PlotTypes.PLOT_LAND] * (self.w*self.h)
        for y in range(self.h):
            for x in range(self.w):
                i = y*self.w + x
                if self.data[x][y] == PlotTypes.PLOT_OCEAN:
                    plotTypes[i] = PlotTypes.PLOT_OCEAN
                elif self.data[x][y] == PlotTypes.PLOT_PEAK:
                    plotTypes[i] = PlotTypes.PLOT_PEAK
                elif self.data[x][y] == PlotTypes.PLOT_HILLS:
                    plotTypes[i] = PlotTypes.PLOT_HILLS
                elif self.data[x][y] == PlotTypes.PLOT_LAND:
                    plotTypes[i] = PlotTypes.PLOT_LAND
                else:
                    plotTypes[i] = PlotTypes.PLOT_LAND
	return plotTypes

def generatePlotTypes():
	NiTextOut("Setting Plot Types (Python WaterWorld) ...")
	gc = CyGlobalContext()
	map = CyMap()
	dice = gc.getGame().getMapRand()
	iW = map.getGridWidth()
	iH = map.getGridHeight()
	
	# Get custom map user inputs.
	typeInput  = map.getCustomMapOption(0)
	seaLevel = map.getSeaLevel()
	hillsPercent = 30

        sizeArray = (
            ((82,10),(72,5),(42,2)), #30% water
            ((87,10),(80,5),(64,2)), #40% water
            ((91,10),(88,5),(80,2)), #50% water
            #((95,10),(92,5),(89,2)), #60% water
            )
        expansionPercent, minLakeSize = sizeArray[seaLevel][typeInput]
        
        map = Map(iW, iH)
        map.makeLakes(expansionPercent)

        map.removeSmallLakes(minLakeSize)
        if debug:
            nLakes = map.countOceanSquares()
            mgr = CyPythonMgr()
            mgr.debugMsg('lakes:%d %f'%(nLakes, float(nLakes)/(iW*iH)))

        map.makeHills(hillsPercent)

        global finalMap
        finalMap = map
        
        return map.getPlotTypes()        

def generateTerrainTypes():
	NiTextOut("Generating Terrain (Python WaterWorld) ...")
	terraingen = TerrainGenerator()
	terrainTypes = terraingen.generateTerrain()
	return terrainTypes

def addFeatures():
	NiTextOut("Adding Features (Python WaterWorld) ...")
	featuregen = FeatureGenerator()
	featuregen.addFeatures()
	return 0

if __name__ == '__main__':
    if len(sys.argv) == 2 and '?' in sys.argv[1]:
        optionString = getOptionString()
        print 'WaterWorld.py ' + optionString
        sys.exit()
    debug = True
    generatePlotTypes()
    finalMap.write()
